/*
 * Decompiled with CFR 0.152.
 */
package xmlui.gscript;

import java.util.Random;
import java.util.Vector;
import xmlui.gscript.Array;
import xmlui.gscript.Bool;
import xmlui.gscript.DataType;
import xmlui.gscript.Int;
import xmlui.gscript.Interpreter;
import xmlui.gscript.Lib;
import xmlui.gscript.Str;

public class Stdlib
extends Lib {
    public static final String[] methodNames = new String[]{"print", "min", "max", "asize", "abs", "random", "mod", "println", "ssize", "equals", "def", "isDef", "valueOf", "idxOf", "substr", "substrB", "replace", "idxofInt", "trim"};
    private static Random random = new Random();

    public String[] getMethodNames() {
        return methodNames;
    }

    public DataType call(Interpreter inp, Vector para, int methodID) {
        switch (methodID) {
            case 0: {
                return this.print(para);
            }
            case 1: {
                return this.min(para);
            }
            case 2: {
                return this.max(para);
            }
            case 3: {
                return this.asize(para);
            }
            case 4: {
                return this.abs(para);
            }
            case 5: {
                return Stdlib.random();
            }
            case 6: {
                return this.mod(para);
            }
            case 7: {
                return this.println(para);
            }
            case 8: {
                return this.ssize(para);
            }
            case 9: {
                return this.equals(para);
            }
            case 10: {
                return this.def(inp, para);
            }
            case 11: {
                return this.isDef(inp, para);
            }
            case 12: {
                return this.valueOf(para);
            }
            case 13: {
                return this.idxof(para);
            }
            case 14: {
                return this.substr(para);
            }
            case 15: {
                return this.substrBegin(para);
            }
            case 16: {
                return this.replace(para);
            }
            case 17: {
                return this.idxofInt(para);
            }
            case 18: {
                return this.trim(para);
            }
        }
        return null;
    }

    private DataType print(Vector para) {
        String s = ((DataType)Interpreter.vPopBack(para)).getString();
        System.out.print(s);
        return null;
    }

    private DataType println(Vector para) {
        String s;
        DataType dt = (DataType)Interpreter.vPopBack(para);
        String string = s = dt == null ? null : dt.getString();
        if (s == null) {
            System.out.println();
        } else {
            System.out.println(s);
        }
        return null;
    }

    private Int min(Vector para) {
        long y;
        long x = ((Int)Interpreter.vPopBack(para)).getVal();
        return new Int(x > (y = ((Int)Interpreter.vPopBack(para)).getVal()) ? y : x);
    }

    private Int max(Vector para) {
        long y;
        long x = ((Int)Interpreter.vPopBack(para)).getVal();
        return new Int(x > (y = ((Int)Interpreter.vPopBack(para)).getVal()) ? x : y);
    }

    private Int asize(Vector para) {
        Array arr = (Array)Interpreter.vPopBack(para);
        return new Int(arr.elements.length);
    }

    private Int abs(Vector para) {
        long x = ((Int)Interpreter.vPopBack(para)).getVal();
        return new Int(Math.abs(x));
    }

    public static DataType random() {
        return new Int(random.nextInt());
    }

    private Int mod(Vector para) {
        long x = ((Int)Interpreter.vPopBack(para)).getVal();
        long y = ((Int)Interpreter.vPopBack(para)).getVal();
        return new Int(x % y);
    }

    private Int ssize(Vector para) {
        String s = Interpreter.vPopBack(para).toString();
        return new Int(s.length());
    }

    private Bool equals(Vector para) {
        String x = ((Str)Interpreter.vPopBack(para)).getVal();
        String y = ((Str)Interpreter.vPopBack(para)).getVal();
        return new Bool(x.equals(y));
    }

    private DataType def(Interpreter inp, Vector para) {
        String name = ((Str)Interpreter.vPopBack(para)).getVal();
        DataType dt = (DataType)Interpreter.vPopBack(para);
        inp.putGolVar(name.toLowerCase(), dt);
        return null;
    }

    private Bool isDef(Interpreter inp, Vector para) {
        String name = ((Str)Interpreter.vPopBack(para)).getVal();
        if (inp.getGolVar(name.toLowerCase()) == null) {
            return new Bool(false);
        }
        return new Bool(true);
    }

    private Int valueOf(Vector para) {
        String s = ((Str)Interpreter.vPopBack(para)).getVal();
        if (s != null) {
            return new Int(Integer.parseInt(s));
        }
        return new Int(0L);
    }

    private Int idxof(Vector para) {
        String m = ((Str)Interpreter.vPopBack(para)).getVal();
        String sub = ((Str)Interpreter.vPopBack(para)).getVal();
        if (m != null && sub != null) {
            return new Int(m.indexOf(sub));
        }
        return new Int(-1L);
    }

    private Int idxofInt(Vector para) {
        String m = ((Str)Interpreter.vPopBack(para)).getVal();
        int sub = ((Int)Interpreter.vPopBack(para)).getValAsInt();
        if (m != null) {
            return new Int(m.indexOf(sub));
        }
        return new Int(-1L);
    }

    private Str substr(Vector para) {
        String s = ((Str)Interpreter.vPopBack(para)).getVal();
        int a2 = ((Int)Interpreter.vPopBack(para)).getValAsInt();
        int b = ((Int)Interpreter.vPopBack(para)).getValAsInt();
        StringBuffer sb = new StringBuffer();
        for (int i = a2; i < b; ++i) {
            if (i >= s.length()) continue;
            sb.append(s.charAt(i));
        }
        return new Str(sb.toString());
    }

    private Str substrBegin(Vector para) {
        String s = ((Str)Interpreter.vPopBack(para)).getVal();
        int a2 = ((Int)Interpreter.vPopBack(para)).getValAsInt();
        int b = s.length();
        StringBuffer sb = new StringBuffer();
        for (int i = a2; i < b; ++i) {
            if (i >= s.length()) continue;
            sb.append(s.charAt(i));
        }
        return new Str(sb.toString());
    }

    private Str replace(Vector para) {
        String s = ((Str)Interpreter.vPopBack(para)).getVal();
        String s1 = ((Str)Interpreter.vPopBack(para)).getVal();
        String s2 = ((Str)Interpreter.vPopBack(para)).getVal();
        return new Str(Interpreter.replace(s, s1, s2));
    }

    private Str trim(Vector para) {
        String s = ((Str)Interpreter.vPopBack(para)).getVal();
        return new Str(s.trim());
    }
}

