/*
 * Decompiled with CFR 0.152.
 */
package xmlui.gscript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import xmlui.gscript.Array;
import xmlui.gscript.Bool;
import xmlui.gscript.DataType;
import xmlui.gscript.Int;
import xmlui.gscript.Lib;
import xmlui.gscript.Obj;
import xmlui.gscript.Stdlib;
import xmlui.gscript.Str;
import xmlui.gscript.Symb;

public class Interpreter {
    private static final String[] STRS_RESERVED = new String[]{"if", "else", "eif", "while", "loop", "sub", "ret"};
    private static final String STR_SYMBOL = "+-*/><()=, []:&|!#";
    private static final String STR_NUMERIC = "0123456789";
    private static final int KEYWORD_IF = 0;
    private static final int KEYWORD_ELSE = 1;
    private static final int KEYWORD_ENDIF = 2;
    private static final int KEYWORD_WHILE = 3;
    private static final int KEYWORD_LOOP = 4;
    private static final int KEYWORD_SUB = 5;
    private static final int KEYWORD_RET = 6;
    public static final int ERR_ILLEGAL = 0;
    public static final int ERR_VAR = 1;
    public static final int ERR_TYPE_INVALID = 2;
    public static final int ERR_NOSUB = 3;
    public static final int ERR_NO_VAR = 4;
    public static final int ERR_PARA_CALC = 5;
    public static final int ERR_PAESEPARA = 6;
    public static final int ERR_NO_SRC = 7;
    public static final int ERR_OPSYMB = 8;
    public static final int ERR_ARR_OUT = 9;
    public static final String[] STRS_ERR = new String[]{" Illegal statment ,", " Invalid variable name ", " Data type error ", " No such method ", " No such variable ", " Method parameter error ", " Parameter count error ", " Code not load yet ", " Operation symbol error  ", " Array out of bounds  "};
    private String[] srcCode;
    private boolean isTopCall;
    private Hashtable golbleVar = new Hashtable();
    private Hashtable subAddr = new Hashtable();
    private Vector extSubList = new Vector();
    static /* synthetic */ Class class$xmlui$gscript$Interpreter;

    private void init() {
        this.srcCode = null;
        this.subAddr.clear();
        this.extSubList.removeAllElements();
        this.golbleVar.clear();
        Stdlib stdlib = new Stdlib();
        this.register(stdlib);
    }

    public void loadFromFile(String path) {
        this.init();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            InputStream is = (class$xmlui$gscript$Interpreter == null ? (class$xmlui$gscript$Interpreter = Interpreter.class$("xmlui.gscript.Interpreter")) : class$xmlui$gscript$Interpreter).getResourceAsStream(path);
            byte[] buff = new byte[512];
            int count = 0;
            while ((count = is.read(buff)) > 0) {
                baos.write(buff, 0, count);
            }
            baos.write(10);
            is.close();
            is = null;
        }
        catch (Exception is) {
            // empty catch block
        }
        byte[] srcBytes = baos.toByteArray();
        try {
            baos.close();
            baos = null;
        }
        catch (IOException buff) {
            // empty catch block
        }
        int lineCount = 1;
        for (int i = 0; i < srcBytes.length; ++i) {
            byte ch = srcBytes[i];
            if (ch == 10) {
                ++lineCount;
            }
            if (ch != 13 && ch != 9) continue;
            srcBytes[i] = 32;
        }
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        this.srcCode = new String[lineCount];
        lineCount = 0;
        for (int i = 0; i < srcBytes.length; ++i) {
            if (srcBytes[i] == 10 || i + 1 == srcBytes.length) {
                try {
                    String s = new String(line.toByteArray());
                    s = s.trim();
                    this.srcCode[lineCount++] = s;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                line.reset();
                continue;
            }
            line.write(srcBytes[i]);
        }
        try {
            line.close();
            line = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.preProcess();
    }

    public void loadFromString(String code) {
        int i;
        this.init();
        int dquodation = 0;
        StringBuffer line = new StringBuffer();
        Vector<String> v = new Vector<String>();
        int len = code.length();
        for (i = 0; i < len; ++i) {
            char ch = code.charAt(i);
            if (ch == '\"') {
                ++dquodation;
            }
            if (dquodation % 2 == 0 && (ch == ';' || ch == '\n')) {
                String s = line.toString().trim();
                if (s.length() > 0) {
                    v.addElement(s);
                }
                line.setLength(0);
                continue;
            }
            line.append(ch);
        }
        this.srcCode = new String[v.size()];
        len = v.size();
        for (i = 0; i < len; ++i) {
            this.srcCode[i] = (String)v.elementAt(i);
        }
        this.preProcess();
    }

    public Lib getLib() {
        return (Lib)this.extSubList.elementAt(0);
    }

    public void removeLib(Lib lib) {
        this.extSubList.removeElement(lib);
    }

    private void preProcess() {
        for (int i = 0; i < this.srcCode.length; ++i) {
            String ins;
            if (this.srcCode[i] == null) {
                this.srcCode[i] = "";
            }
            if (this.srcCode[i].indexOf(35) >= 0) {
                int dqCount = 0;
                for (int m = 0; m < this.srcCode[i].length(); ++m) {
                    char ch = this.srcCode[i].charAt(m);
                    if (ch == '\"') {
                        ++dqCount;
                    }
                    if (ch != '#' || dqCount % 2 != 0) continue;
                    this.srcCode[i] = this.srcCode[i].substring(0, m);
                    break;
                }
                this.srcCode[i] = this.srcCode[i].trim();
            }
            if (!(ins = this.srcCode[i]).startsWith(STRS_RESERVED[5] + " ")) continue;
            String subName = this.getFirstWord(ins.substring(ins.indexOf(STRS_RESERVED[5]) + STRS_RESERVED[5].length()));
            this.subAddr.put(subName, new Int(i));
        }
    }

    public Object start() {
        return this.start(null);
    }

    public Object start(Hashtable env) {
        this.isTopCall = true;
        try {
            if (this.srcCode != null) {
                if (env != null) {
                    Enumeration e = env.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        Object val = env.get(key);
                        key = ((String)key).toLowerCase();
                        this.golbleVar.put(key, val);
                    }
                }
                return this.callSub(null, null);
            }
            this.errout(0, STRS_ERR[7]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Object callSub(String instract) {
        try {
            Hashtable ht = new Hashtable();
            return this.callSub(instract, ht);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void putGolVar(String varName, DataType value) {
        this.golbleVar.put(varName, value);
    }

    public Object getGolVar(String varName) {
        return this.golbleVar.get(varName);
    }

    public void register(Lib lib) {
        this.extSubList.addElement(lib);
    }

    private Object _sub(Vector paraStack, int instrucPointer) {
        Hashtable<String, Object> localVar;
        int ip = instrucPointer;
        if (this.isTopCall) {
            localVar = this.golbleVar;
            this.isTopCall = false;
        } else {
            localVar = new Hashtable<String, Object>();
        }
        long calls = System.currentTimeMillis();
        try {
            String inst = this.srcCode[ip];
            if (this.getFirstWord(inst).equals(STRS_RESERVED[5])) {
                String paraName = inst.substring(inst.indexOf(40) + 1, inst.lastIndexOf(41));
                Vector sName = this.parseInstruct(paraName);
                while (sName.size() > 0) {
                    String pName = (String)Interpreter.vPopFront(sName);
                    if (pName.charAt(0) == ',') continue;
                    localVar.put(pName, Interpreter.vPopBack(paraStack));
                }
                ++ip;
            }
        }
        catch (Exception ex1) {
            this.errout(ip, STRS_ERR[6]);
        }
        calls = System.currentTimeMillis() - calls;
        calls = System.currentTimeMillis();
        while (ip < this.srcCode.length) {
            block42: {
                try {
                    String instruct = this.srcCode[ip];
                    if (instruct.length() == 0) break block42;
                    int keywordCode = this.getKeywordCode(this.getFirstWord(instruct));
                    if (keywordCode >= 0) {
                        block2 : switch (keywordCode) {
                            case 3: {
                                Bool wb = (Bool)this.calcExpr(instruct.substring(STRS_RESERVED[3].length()), localVar);
                                if (wb.getVal()) break;
                                int countWhile = 1;
                                for (int i = ip + 1; i < this.srcCode.length; ++i) {
                                    String tmpHead = this.getFirstWord(this.srcCode[i]);
                                    if (tmpHead.equals(STRS_RESERVED[3])) {
                                        ++countWhile;
                                    } else if (tmpHead.equals(STRS_RESERVED[4])) {
                                        --countWhile;
                                    }
                                    if (!tmpHead.equals(STRS_RESERVED[4]) || countWhile != 0) continue;
                                    ip = i;
                                    break block2;
                                }
                                break block42;
                            }
                            case 4: {
                                int countWhile = 1;
                                for (int i = ip - 1; i > 0; --i) {
                                    String tmpHead = this.getFirstWord(this.srcCode[i]);
                                    if (tmpHead.equals(STRS_RESERVED[3])) {
                                        --countWhile;
                                    } else if (tmpHead.equals(STRS_RESERVED[4])) {
                                        ++countWhile;
                                    }
                                    if (!tmpHead.equals(STRS_RESERVED[3]) || countWhile != 0) continue;
                                    ip = i - 1;
                                    break block2;
                                }
                                break block42;
                            }
                            case 0: {
                                String tmpHead;
                                int i;
                                Bool ib = (Bool)this.calcExpr(instruct.substring(STRS_RESERVED[0].length()), localVar);
                                if (ib.getVal()) break;
                                int countIf = 1;
                                for (i = ip + 1; i < this.srcCode.length; ++i) {
                                    tmpHead = this.getFirstWord(this.srcCode[i]);
                                    if (tmpHead.equals(STRS_RESERVED[0])) {
                                        ++countIf;
                                    } else if (tmpHead.equals(STRS_RESERVED[2])) {
                                        --countIf;
                                    }
                                    if (tmpHead.equals(STRS_RESERVED[1]) && countIf == 1) {
                                        ip = i;
                                        break block2;
                                    }
                                    if (!tmpHead.equals(STRS_RESERVED[2]) || countIf != 0) continue;
                                    ip = i;
                                    break block2;
                                }
                                break block42;
                            }
                            case 1: {
                                String tmpHead;
                                int i;
                                int countIf = 1;
                                for (i = ip + 1; i < this.srcCode.length; ++i) {
                                    tmpHead = this.getFirstWord(this.srcCode[i]);
                                    if (tmpHead.equals(STRS_RESERVED[0])) {
                                        ++countIf;
                                    } else if (tmpHead.equals(STRS_RESERVED[2])) {
                                        --countIf;
                                    }
                                    if (!tmpHead.equals(STRS_RESERVED[2]) || countIf != 0) continue;
                                    ip = i;
                                    break block2;
                                }
                                break block42;
                            }
                            case 5: {
                                return null;
                            }
                            case 6: {
                                if (instruct.length() > STRS_RESERVED[6].length()) {
                                    return this.calcExpr(instruct.substring(instruct.indexOf(" ")), localVar);
                                }
                                return null;
                            }
                        }
                        break block42;
                    }
                    if (this.isArr(instruct)) {
                        this._setArr(instruct, localVar);
                    } else if (this.isSubCall(instruct)) {
                        this.callSub(instruct, localVar);
                    } else if (this.isVar(instruct)) {
                        this._setVar(instruct, localVar);
                    } else {
                        this.errout(ip, STRS_ERR[0]);
                    }
                }
                catch (Exception ex) {
                    this.errout(ip, STRS_ERR[0] + ex.getMessage());
                    ex.printStackTrace();
                    break;
                }
            }
            ++ip;
        }
        calls = System.currentTimeMillis() - calls;
        return null;
    }

    private String getFirstWord(String instruct) {
        instruct = instruct.trim();
        StringBuffer tsb = new StringBuffer();
        for (int i = 0; i < instruct.length() && !this.isSymbol(instruct.charAt(i)); ++i) {
            tsb.append(instruct.charAt(i));
        }
        return tsb.toString().trim().toLowerCase();
    }

    private int getKeywordCode(String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        for (int i = 0; i < STRS_RESERVED.length; ++i) {
            if (!s.equals(STRS_RESERVED[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean isSubCall(String s) {
        return this.getInstructType(s) == '(';
    }

    private boolean isVar(String s) {
        return this.getInstructType(s) == '=';
    }

    private boolean isArr(String s) {
        return this.getInstructType(s) == '[';
    }

    private char getInstructType(String instruct) {
        for (int i = 0; i < instruct.length(); ++i) {
            if ("(=[".indexOf(instruct.charAt(i)) < 0) continue;
            return instruct.charAt(i);
        }
        return '\u0000';
    }

    private boolean isSymbol(char ch) {
        return STR_SYMBOL.indexOf(ch) >= 0;
    }

    private boolean isNumeric(char ch) {
        return STR_NUMERIC.indexOf(ch) >= 0;
    }

    private boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private Vector parseInstruct(String s) {
        Vector stack = new Vector();
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ' ') continue;
            if (ch == '\'') break;
            if (ch == '\"') {
                sb.append(ch);
                ++i;
                while (i < s.length()) {
                    ch = s.charAt(i);
                    sb.append(ch);
                    if (ch != '\"') {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (this.isSymbol(ch)) {
                sb.append(ch);
                if (ch == '>') {
                    if (i + 1 < len && s.charAt(i + 1) == '=') {
                        sb.append(s.charAt(i + 1));
                        ++i;
                    }
                } else if (ch == '<' && i + 1 < len && (s.charAt(i + 1) == '=' || s.charAt(i + 1) == '>')) {
                    sb.append(s.charAt(i + 1));
                    ++i;
                }
            } else if (this.isLetter(ch)) {
                int leftQ;
                while (i < s.length() && !this.isSymbol(ch = s.charAt(i))) {
                    sb.append(ch);
                    ++i;
                }
                while (i < s.length() && (ch = s.charAt(i)) == ' ') {
                    ++i;
                }
                if (ch == '[') {
                    leftQ = 0;
                    do {
                        if (ch == '[') {
                            ++leftQ;
                        }
                        if (ch == ']') {
                            --leftQ;
                        }
                        sb.append(ch);
                    } while (++i < s.length() && ("+-*/,)=:><".indexOf(ch = s.charAt(i)) < 0 || leftQ > 0));
                } else if (ch == '(') {
                    leftQ = 0;
                    do {
                        if ((ch = s.charAt(i)) == '(') {
                            ++leftQ;
                        }
                        if (ch == ')') {
                            --leftQ;
                        }
                        sb.append(ch);
                    } while (leftQ > 0 && ++i < s.length());
                }
                --i;
            } else if (this.isNumeric(ch)) {
                while (i < s.length()) {
                    ch = s.charAt(i);
                    if (this.isSymbol(ch)) {
                        --i;
                        break;
                    }
                    sb.append(ch);
                    ++i;
                }
            }
            Interpreter.vPushBack(stack, sb.toString());
            sb.setLength(0);
        }
        return stack;
    }

    private void errout(int ip, String s) {
        System.out.println(ip + 1 + " " + this.srcCode[ip] + " : " + s);
    }

    private boolean isStr(Object o) {
        return o instanceof Str;
    }

    private boolean isObj(Object o) {
        return o instanceof Obj;
    }

    private boolean isInt(Object o) {
        return o instanceof Int;
    }

    private boolean isArr(Object o) {
        return o instanceof Array;
    }

    private boolean isBool(Object o) {
        return o instanceof Bool;
    }

    private boolean isSymb(Object o) {
        return o instanceof Symb;
    }

    public static final Object vPopFront(Vector v) {
        if (v.size() <= 0) {
            return null;
        }
        Object o = v.firstElement();
        if (v.size() > 0) {
            v.removeElementAt(0);
        }
        return o;
    }

    public static final Object vPopBack(Vector v) {
        if (v.size() <= 0) {
            return null;
        }
        Object o = v.lastElement();
        if (v.size() > 0) {
            v.removeElementAt(v.size() - 1);
        }
        return o;
    }

    public static final void vPushFront(Vector v, Object o) {
        v.insertElementAt(o, 0);
    }

    public static final void vPushBack(Vector v, Object o) {
        v.addElement(o);
    }

    private Object _getVar(String name, Hashtable localVar) {
        Object value = localVar.get(name = name.toLowerCase());
        if (value == null) {
            value = this.golbleVar.get(name);
        }
        if (value != null) {
            return value;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _setVar(String instruct, Hashtable varList) throws Exception {
        String exprStr = instruct.substring(instruct.indexOf(61) + 1);
        Vector expr = this.parseInstruct(instruct);
        String varName = (String)Interpreter.vPopFront(expr);
        varName = varName.toLowerCase();
        Object varValue = this._getVar(varName, varList);
        String symb = (String)Interpreter.vPopFront(expr);
        if (symb.charAt(0) != '=') throw new Exception(STRS_ERR[1]);
        Object newVarValue = this.calcExpr(exprStr, varList);
        if (newVarValue == null) return;
        if (varValue == null) {
            varList.put(varName, newVarValue);
            return;
        } else {
            if (!(this.isStr(newVarValue) && this.isStr(varValue) || this.isInt(newVarValue) && this.isInt(varValue) || this.isBool(newVarValue) && this.isBool(varValue)) && (!this.isArr(newVarValue) || !this.isArr(varValue))) throw new Exception(STRS_ERR[2]);
            if (varList.get(varName) != null) {
                varList.put(varName, newVarValue);
                return;
            } else {
                this.golbleVar.put(varName, newVarValue);
            }
        }
    }

    Object calcExpr(String exprStr, Hashtable varList) throws Exception {
        Vector expr = this.parseInstruct(exprStr);
        expr = this.preCalc(expr, varList);
        boolean T_NUM = true;
        int T_STR = 2;
        int T_LOG = 4;
        int T_ARR = 8;
        int T_LOGSYM = 16;
        int cType = 0;
        int cType1 = 0;
        for (int i = 0; i < expr.size(); ++i) {
            Object o = expr.elementAt(i);
            if (this.isStr(o) || this.isObj(o)) {
                cType |= 2;
                continue;
            }
            if (this.isSymb(o)) {
                if (!((Symb)o).isLogicOp()) continue;
                cType |= 0x10;
                continue;
            }
            if (this.isBool(o)) {
                cType |= 4;
                continue;
            }
            if (this.isArr(o)) {
                cType |= 8;
                continue;
            }
            if (!this.isInt(o)) continue;
            cType |= 1;
        }
        if (cType & true && (cType & 2) == 0 && (cType & 8) == 0 && (cType & 4) == 0 && (cType & 0x10) == 0) {
            cType1 = 1;
        } else if ((cType & 2) != 0 && (cType & 0x10) == 0) {
            cType1 = 2;
        } else if (((cType & 4) != 0 || (cType & 0x10) != 0) && (cType & 2) == 0 && (cType & 8) == 0) {
            cType1 = 4;
        } else if ((cType & 8) != 0 && (cType & 2) == 0 && (cType & 1) == 0 && (cType & 4) == 0 && (cType & 0x10) == 0) {
            cType1 = 8;
        } else {
            throw new Exception(STRS_ERR[0]);
        }
        Object resultDt = null;
        switch (cType1) {
            case 1: {
                while (expr.size() > 1) {
                    this.calcExprNumImpl(expr);
                }
                resultDt = Interpreter.vPopBack(expr);
                break;
            }
            case 2: {
                this.calcExprStrImpl(expr);
                resultDt = Interpreter.vPopBack(expr);
                break;
            }
            case 4: {
                Vector log_dElem = new Vector();
                Vector ari_dElem = new Vector();
                while (expr.size() > 0) {
                    Symb pst;
                    Object pdt = Interpreter.vPopFront(expr);
                    ari_dElem.removeAllElements();
                    if (this.isSymb(pdt) && (pst = (Symb)pdt).isCompOp()) {
                        int rightQ = 0;
                        while (log_dElem.size() > 0) {
                            Object pdt2 = Interpreter.vPopBack(log_dElem);
                            if (this.isSymb(pdt2)) {
                                if (((Symb)pdt2).getVal() == 15) {
                                    ++rightQ;
                                }
                                if (((Symb)pdt2).isLogicOp() || ((Symb)pdt2).getVal() == 14 && rightQ == 0) {
                                    Interpreter.vPushBack(log_dElem, pdt2);
                                    break;
                                }
                                if (((Symb)pdt2).getVal() == 14) {
                                    --rightQ;
                                }
                            }
                            Interpreter.vPushFront(ari_dElem, pdt2);
                        }
                        while (ari_dElem.size() > 1) {
                            this.calcExprNumImpl(ari_dElem);
                        }
                        if (ari_dElem.size() > 0) {
                            Interpreter.vPushBack(log_dElem, Interpreter.vPopFront(ari_dElem));
                        }
                    }
                    Interpreter.vPushBack(log_dElem, pdt);
                    ari_dElem.removeAllElements();
                    if (!this.isSymb(pdt) || !((Symb)pdt).isCompOp()) continue;
                    int leftQ = 0;
                    while (expr.size() > 0) {
                        Object pdt2 = Interpreter.vPopFront(expr);
                        if (this.isSymb(pdt2)) {
                            Symb pst2 = (Symb)pdt2;
                            byte opType = pst2.getVal();
                            if (opType == 14) {
                                ++leftQ;
                            }
                            if (pst2.isLogicOp() || opType == 15 && leftQ == 0) {
                                Interpreter.vPushFront(expr, pdt2);
                                break;
                            }
                            if (opType == 15) {
                                --leftQ;
                            }
                        }
                        Interpreter.vPushBack(ari_dElem, pdt2);
                    }
                    while (ari_dElem.size() > 1) {
                        this.calcExprNumImpl(ari_dElem);
                    }
                    if (ari_dElem.size() <= 0) continue;
                    Interpreter.vPushBack(log_dElem, Interpreter.vPopFront(ari_dElem));
                }
                while (log_dElem.size() > 1) {
                    this.calcExprLgcImpl(log_dElem);
                }
                resultDt = Interpreter.vPopBack(log_dElem);
                break;
            }
            case 8: {
                resultDt = Interpreter.vPopBack(expr);
                break;
            }
            default: {
                throw new Exception(STRS_ERR[0]);
            }
        }
        return resultDt;
    }

    private Vector preCalc(Vector expr, Hashtable varList) throws Exception {
        Vector tgt = new Vector();
        while (expr.size() > 0) {
            Object o = Interpreter.vPopFront(expr);
            String s = (String)o;
            if (s.charAt(0) == '\"') {
                s = s.substring(1, s.length() - 1);
                o = new Str(s);
            } else if (this.isSymbol(s.charAt(0))) {
                o = new Symb(s);
                if (((Symb)o).getVal() == 0) {
                    throw new Exception(s + STRS_ERR[8]);
                }
            } else if (this.isNumeric(s.charAt(0))) {
                o = new Int(s);
            } else if (s.charAt(s.length() - 1) == ')') {
                o = this.callSub(s, varList);
            } else if (s.charAt(s.length() - 1) == ']') {
                o = this._getArr(s, varList);
            } else if (Bool.isBool(s)) {
                o = new Bool(s);
            } else {
                o = this._getVar(s, varList);
                if (o == null) {
                    throw new Exception(s + STRS_ERR[4]);
                }
            }
            Interpreter.vPushBack(tgt, o);
        }
        return tgt;
    }

    private void calcExprStrImpl(Vector expr) {
        StringBuffer sb = new StringBuffer();
        while (expr.size() > 0) {
            Object ts = Interpreter.vPopFront(expr);
            if (ts instanceof Symb) continue;
            sb.append(((DataType)ts).getString());
        }
        Interpreter.vPushFront(expr, new Str(sb.toString()));
    }

    private void calcExprNumImpl(Vector expr) {
        if (expr.size() == 1) {
            return;
        }
        Object element1 = Interpreter.vPopFront(expr);
        if (element1 instanceof Symb) {
            if (((Symb)element1).getVal() == 14) {
                this.calcExprNumImpl(expr);
                Object element2 = Interpreter.vPopFront(expr);
                Object element3 = Interpreter.vPopFront(expr);
                if (element3 instanceof Symb && ((Symb)element3).getVal() == 15) {
                    Interpreter.vPushFront(expr, element2);
                } else {
                    Interpreter.vPushFront(expr, element3);
                    Interpreter.vPushFront(expr, element2);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprNumImpl(expr);
                }
            } else if (((Symb)element1).getVal() == 1) {
                this.calcExprNumImpl(expr);
            } else if (((Symb)element1).getVal() == 2) {
                Object element2 = Interpreter.vPopFront(expr);
                if (element2 instanceof Int) {
                    element2 = new Int(-((Int)element2).getVal());
                    Interpreter.vPushFront(expr, element2);
                } else {
                    Interpreter.vPushFront(expr, element2);
                    this.calcExprNumImpl(expr);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprNumImpl(expr);
                }
            }
        } else if (element1 instanceof Int) {
            Symb element2 = (Symb)Interpreter.vPopFront(expr);
            Object element3 = Interpreter.vPopFront(expr);
            if (element2.getVal() == 3 || element2.getVal() == 4) {
                if (element3 instanceof Int) {
                    long n1 = ((Int)element1).getVal();
                    long n2 = ((Int)element3).getVal();
                    Int val = new Int(element2.getVal() == 3 ? n1 * n2 : n1 / n2);
                    Interpreter.vPushFront(expr, val);
                } else {
                    Interpreter.vPushFront(expr, element3);
                    this.calcExprNumImpl(expr);
                    Interpreter.vPushFront(expr, element2);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprNumImpl(expr);
                }
            } else if (element2.getVal() == 1 || element2.getVal() == 2) {
                boolean calc = false;
                if (element3 instanceof Int) {
                    if (expr.size() == 0) {
                        calc = true;
                    } else {
                        Object element4 = Interpreter.vPopFront(expr);
                        if (element4 != null) {
                            if (((Symb)element4).getVal() != 3 && ((Symb)element4).getVal() != 4) {
                                calc = true;
                            }
                            Interpreter.vPushFront(expr, element4);
                        }
                    }
                }
                if (calc) {
                    long n1 = ((Int)element1).getVal();
                    long n2 = ((Int)element3).getVal();
                    Int val = new Int(element2.getVal() == 1 ? n1 + n2 : n1 - n2);
                    Interpreter.vPushFront(expr, val);
                } else {
                    Interpreter.vPushFront(expr, element3);
                    this.calcExprNumImpl(expr);
                    Interpreter.vPushFront(expr, element2);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprNumImpl(expr);
                }
            } else if (element2.getVal() == 15) {
                if (element3 != null) {
                    Interpreter.vPushFront(expr, element3);
                }
                Interpreter.vPushFront(expr, element2);
                Interpreter.vPushFront(expr, element1);
                return;
            }
        }
    }

    private void calcExprLgcImpl(Vector expr) {
        if (expr.size() == 1) {
            return;
        }
        Object element1 = Interpreter.vPopFront(expr);
        if (element1 instanceof Symb) {
            if (((Symb)element1).getVal() == 14) {
                this.calcExprLgcImpl(expr);
                Object element2 = Interpreter.vPopFront(expr);
                Object element3 = Interpreter.vPopFront(expr);
                if (element3 instanceof Symb && ((Symb)element3).getVal() == 15) {
                    Interpreter.vPushFront(expr, element2);
                } else {
                    Interpreter.vPushFront(expr, element3);
                    Interpreter.vPushFront(expr, element2);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprLgcImpl(expr);
                }
            } else if (((Symb)element1).getVal() == 11) {
                Object element2 = Interpreter.vPopFront(expr);
                if (element2 instanceof Bool) {
                    element2 = new Bool(!((Bool)element2).getVal());
                    Interpreter.vPushFront(expr, element2);
                } else {
                    Interpreter.vPushFront(expr, element2);
                    this.calcExprLgcImpl(expr);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprLgcImpl(expr);
                }
            }
        } else if (element1 instanceof Int) {
            long n1 = ((Int)element1).getVal();
            Object element2 = Interpreter.vPopFront(expr);
            Object element3 = Interpreter.vPopFront(expr);
            Symb operator = (Symb)element2;
            long n2 = ((Int)element3).getVal();
            boolean result = false;
            if (operator.getVal() == 5) {
                result = n1 > n2;
            } else if (operator.getVal() == 6) {
                result = n1 < n2;
            } else if (operator.getVal() == 8) {
                result = n1 >= n2;
            } else if (operator.getVal() == 9) {
                result = n1 <= n2;
            } else if (operator.getVal() == 10) {
                result = n1 != n2;
            } else if (operator.getVal() == 7) {
                result = n1 == n2;
            }
            Interpreter.vPushFront(expr, new Bool(result));
        } else if (element1 instanceof Bool) {
            Symb element2 = (Symb)Interpreter.vPopFront(expr);
            Object element3 = Interpreter.vPopFront(expr);
            if (element2.getVal() == 12) {
                if (element3 instanceof Bool) {
                    boolean result = ((Bool)element1).getVal() && ((Bool)element3).getVal();
                    Interpreter.vPushFront(expr, new Bool(result));
                } else {
                    Interpreter.vPushFront(expr, element3);
                    this.calcExprLgcImpl(expr);
                    Interpreter.vPushFront(expr, element2);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprLgcImpl(expr);
                }
            } else if (element2.getVal() == 13) {
                boolean calc = false;
                if (element3 instanceof Bool) {
                    if (expr.size() == 0) {
                        calc = true;
                    } else {
                        Object element4 = Interpreter.vPopFront(expr);
                        if (element4 instanceof Symb && ((Symb)element4).getVal() != 12) {
                            calc = true;
                        }
                        Interpreter.vPushFront(expr, element4);
                    }
                }
                if (calc) {
                    boolean result = ((Bool)element1).getVal() || ((Bool)element3).getVal();
                    Interpreter.vPushFront(expr, new Bool(result));
                } else {
                    Interpreter.vPushFront(expr, element3);
                    this.calcExprLgcImpl(expr);
                    Interpreter.vPushFront(expr, element2);
                    Interpreter.vPushFront(expr, element1);
                    this.calcExprLgcImpl(expr);
                }
            } else if (element2.getVal() == 15) {
                if (element3 != null) {
                    Interpreter.vPushFront(expr, element3);
                }
                Interpreter.vPushFront(expr, element2);
                Interpreter.vPushFront(expr, element1);
                return;
            }
        }
    }

    private Object callSub(String instruct, Hashtable varList) throws Exception {
        String subName;
        Object addr;
        if (instruct == null) {
            return this._sub(null, 0);
        }
        String paraVal = instruct.substring(instruct.indexOf(40) + 1, instruct.lastIndexOf(41));
        Vector paraStack = new Vector();
        if (paraVal.length() != 0) {
            Vector sValue = this.parseInstruct(paraVal);
            while (sValue.size() > 0) {
                String tmps;
                StringBuffer exprStrBuf = new StringBuffer();
                while (sValue.size() > 0 && (tmps = Interpreter.vPopFront(sValue).toString()).charAt(0) != ',') {
                    exprStrBuf.append(tmps);
                }
                String exprStr = exprStrBuf.toString();
                Object v = this.calcExpr(exprStr, varList);
                if (v != null) {
                    Interpreter.vPushFront(paraStack, v);
                    continue;
                }
                throw new Exception(STRS_ERR[5] + exprStr);
            }
        }
        if ((addr = this.subAddr.get(subName = this.getFirstWord(instruct))) != null) {
            int ip = ((Int)addr).getValAsInt();
            return this._sub(paraStack, ip);
        }
        for (int i = 0; i < this.extSubList.size(); ++i) {
            Lib ext = (Lib)this.extSubList.elementAt(i);
            int mID = ext.getMethodID(subName);
            if (mID < 0) continue;
            DataType re = ext.call(this, paraStack, mID);
            return re;
        }
        throw new Exception(STRS_ERR[3]);
    }

    private Vector parseArrayPos(String arrStr, Hashtable varList) throws Exception {
        Vector stack = new Vector();
        arrStr = arrStr.substring(arrStr.indexOf(91));
        int leftQ = 0;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arrStr.length(); ++i) {
            char ch = arrStr.charAt(i);
            if (ch == '[') {
                if (leftQ > 0) {
                    sb.append(ch);
                }
                ++leftQ;
                continue;
            }
            if (ch == ']') {
                if (--leftQ == 0) {
                    Object o = this.calcExpr(sb.toString(), varList);
                    if (!(o instanceof Int)) {
                        throw new Exception(STRS_ERR[2]);
                    }
                    Interpreter.vPushBack(stack, o);
                    sb.setLength(0);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return stack;
    }

    private void _setArr(String instruct, Hashtable varList) throws Exception {
        Vector stack = this.parseInstruct(instruct);
        String leftStr = (String)Interpreter.vPopFront(stack);
        String arrName = this.getFirstWord(leftStr);
        arrName = arrName.toLowerCase();
        Vector paraStack = this.parseArrayPos(leftStr, varList);
        int deepth = paraStack.size();
        int[] dimPara = new int[deepth];
        for (int i = dimPara.length - 1; i >= 0; --i) {
            dimPara[i] = ((Int)Interpreter.vPopBack(paraStack)).getValAsInt();
        }
        if (stack.size() == 0 || stack.size() != 0 && ((String)Interpreter.vPopFront(stack)).charAt(0) == ':') {
            Array arr = new Array(dimPara);
            varList.put(arrName, arr);
        } else {
            Object arr = varList.get(arrName);
            if (arr == null) {
                arr = this.golbleVar.get(arrName);
            }
            if (arr != null && arr instanceof Array) {
                String exprStr = instruct.substring(instruct.indexOf(61) + 1);
                ((Array)arr).setValue(dimPara, this.calcExpr(exprStr, varList));
            }
        }
    }

    private Object _getArr(String arrExpr, Hashtable varList) throws Exception {
        String arrName = this.getFirstWord(arrExpr);
        arrName = arrName.toLowerCase();
        Vector paraStack = this.parseArrayPos(arrExpr, varList);
        int deepth = paraStack.size();
        int[] dimPara = new int[deepth];
        for (int i = dimPara.length - 1; i >= 0; --i) {
            dimPara[i] = ((Int)Interpreter.vPopBack(paraStack)).getValAsInt();
        }
        Object arr = this._getVar(arrName, varList);
        if (arr != null && arr instanceof Array) {
            return ((Array)arr).getValue(dimPara);
        }
        return null;
    }

    public static final String replace(String s1, String s2, String s3) {
        if (s1 == null || s2 == null || s3 == null) {
            return s1;
        }
        try {
            while (-1 != s1.indexOf(s2)) {
                s1 = s1.substring(0, s1.indexOf(s2)) + s3 + s1.substring(s1.indexOf(s2) + s2.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

