/*
 * Decompiled with CFR 0.152.
 */
package xmlui.gscript;

import xmlui.gscript.DataType;
import xmlui.gscript.Int;

public class Array
extends DataType {
    byte deepth = 0;
    DataType[] elements;

    public Array(int[] dimSize) {
        this.init(dimSize);
    }

    private void init(int[] dimSize) {
        this.deepth = (byte)dimSize.length;
        int len = dimSize[0];
        if (this.deepth > 1) {
            int[] newDimSize = new int[this.deepth - 1];
            System.arraycopy(dimSize, 1, newDimSize, 0, this.deepth - 1);
            this.elements = new Array[len];
            for (int i = 0; i < ((Array[])this.elements).length; ++i) {
                this.elements[i] = new Array(newDimSize);
            }
        } else {
            this.elements = new DataType[len];
            for (int i = 0; i < len; ++i) {
                this.elements[i] = new Int(0L);
            }
        }
    }

    public Object getValue(int[] pos) {
        Array arr = this;
        for (int i = 0; i < pos.length; ++i) {
            if (arr.deepth == 1) {
                return arr.elements[pos[i]];
            }
            arr = (Array)arr.elements[pos[i]];
        }
        return arr;
    }

    public void setValue(int[] pos, Object value) {
        Array arr = this;
        for (int i = 0; i < pos.length; ++i) {
            if (arr.deepth == 1) {
                arr.elements[pos[i]] = (DataType)value;
                continue;
            }
            arr = (Array)arr.elements[pos[i]];
        }
    }

    public String getString() {
        return "Array[" + this.elements == null ? "" : this.elements.length + "]";
    }
}

