/*
 * Decompiled with CFR 0.152.
 */
package xmlui;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import xmlui.ResManager;

public class XImage {
    public Image img;
    public short frame_w = 0;
    public short frame_h = 0;
    public byte cols = 0;
    public byte rows = 0;
    public byte frames = 0;

    public XImage(String imagePath, int f_w, int f_h) {
        if (f_w == 0 || f_h == 0) {
            return;
        }
        this.frame_w = (short)f_w;
        this.frame_h = (short)f_h;
        this.img = XImage.loadImage(imagePath);
        this.cols = (byte)(this.img.getWidth() / this.frame_w);
        this.rows = (byte)(this.img.getHeight() / this.frame_h);
        this.frames = (byte)(this.cols * this.rows);
    }

    public XImage(Image img) {
        if (img == null) {
            return;
        }
        this.img = img;
        this.frame_w = (short)img.getWidth();
        this.frame_h = (short)img.getHeight();
        this.frames = 1;
        this.rows = 1;
        this.cols = 1;
    }

    public XImage(String s) {
        this.img = XImage.loadImage(s);
        this.frame_w = (short)this.img.getWidth();
        this.frame_h = (short)this.img.getHeight();
        this.cols = 1;
        this.rows = 1;
        this.frames = 1;
    }

    public void draw(Graphics g, int x, int y, int frameIndex, int transform) {
        if (this.img != null) {
            ResManager.drawRegion(g, this.img, this.frame_w * (frameIndex % this.cols), this.frame_h * (frameIndex / this.cols), this.frame_w, this.frame_h, transform, x, y, 20);
        }
    }

    private static int returnCRCnum(byte byte0, int k) {
        int colornumber = byte0 & 0xFF;
        k ^= colornumber;
        for (int i1 = 0; i1 < 8; ++i1) {
            if ((k & 1) != 0) {
                k = k >>> 1 ^ 0xEDB88320;
                continue;
            }
            k >>>= 1;
        }
        return k;
    }

    public static Image loadImage(String imgPath) {
        Image img = null;
        try {
            img = Image.createImage((String)imgPath);
        }
        catch (IOException ioe) {
            System.out.println("\u52a0\u8f7d\u56fe\u7247\"" + imgPath + "\"\u51fa\u9519");
            ioe.printStackTrace();
        }
        return img;
    }
}

