/*
 * Decompiled with CFR 0.152.
 */
package xmlui;

import java.util.Vector;
import org.kxml2.io.KXmlParser;
import xmlui.XAction;
import xmlui.XBr;
import xmlui.XComponent;
import xmlui.XInput;
import xmlui.XTable;
import xmlui.XTd;
import xmlui.XTr;

public abstract class XContainer
extends XComponent {
    private XComponent[] children = new XComponent[4];
    private short len = 0;
    int depth = -1;

    public void add(XComponent xcon) {
        if (this.children.length <= this.len) {
            this.expand();
        }
        this.children[this.len] = xcon;
        this.len = (short)(this.len + 1);
        xcon.parents = this;
    }

    public void remove(XComponent xcon) {
        boolean move = false;
        for (int i = 0; i < this.len; ++i) {
            if (this.children[i] == xcon || move) {
                move = true;
                if (i + 1 >= this.children.length) continue;
                this.children[i] = this.children[i + 1];
                continue;
            }
            if (!(this.children[i] instanceof XContainer)) continue;
            ((XContainer)this.children[i]).remove(xcon);
        }
        if (move) {
            this.len = (short)(this.len - 1);
        }
    }

    public void remove(int index) {
        if (index >= this.children.length) {
            return;
        }
        XComponent xc = this.children[index];
        this.remove(xc);
    }

    public void removeall() {
        this.len = 0;
        this.children = new XComponent[4];
    }

    public boolean subst(String oldName, XComponent newComponent) {
        if (oldName == null) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (oldName.equals(this.children[i].elementName)) {
                newComponent.x = this.children[i].x;
                newComponent.y = this.children[i].y;
                this.children[i] = newComponent;
                newComponent.parents = this;
                return true;
            }
            if (!(this.children[i] instanceof XContainer) || !((XContainer)this.children[i]).subst(oldName, newComponent)) continue;
            return true;
        }
        return false;
    }

    public XComponent elementAt(int i) {
        if (this.size() > i && i >= 0) {
            return this.children[i];
        }
        return null;
    }

    public int indexOf(XComponent xc) {
        for (int i = 0; i < this.len; ++i) {
            if (this.children[i] != xc) continue;
            return i;
        }
        return -1;
    }

    public void insert(XComponent xc, int index) {
        if (this.children.length <= this.len) {
            this.expand();
        }
        if (index <= this.len) {
            for (int i = this.len - 1; i >= index; --i) {
                this.children[i + 1] = this.children[i];
            }
            this.children[index] = xc;
            xc.parents = this;
            this.len = (short)(this.len + 1);
        }
    }

    public int size() {
        return this.len;
    }

    public void parseSon(KXmlParser parser) throws Exception {
        String name = parser.getName();
        if (name.equals("br")) {
            XBr xbr = new XBr(this);
            xbr.parse(parser);
            this.add(xbr);
        } else if (name.equals("a")) {
            XAction xaction = new XAction(this);
            xaction.parse(parser);
            this.add(xaction);
        } else if (name.equals("i")) {
            XInput xinput = new XInput(this);
            xinput.parse(parser);
            this.add(xinput);
        } else if (name.equals("tb")) {
            XTable xtb = new XTable(this);
            xtb.parse(parser);
            this.add(xtb);
        } else if (name.equals("tr")) {
            XTr xtr = new XTr(this);
            xtr.parse(parser);
            this.add(xtr);
        } else if (name.equals("td")) {
            XTd xtd = new XTd(this);
            xtd.parse(parser);
            this.add(xtd);
        }
    }

    public void parseText(KXmlParser parser) throws Exception {
        String tmp = parser.getText();
        if (tmp != null) {
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            if ((tmp = tmp.trim()).length() > 0) {
                XAction xaction = new XAction(this);
                xaction.setText(tmp);
                this.add(xaction);
            }
        }
    }

    private void expand() {
        XComponent[] tmpxc = new XComponent[this.children.length << 1];
        System.arraycopy(this.children, 0, tmpxc, 0, this.len);
        this.children = tmpxc;
    }

    public XComponent find(String xcname) {
        if (this.elementName != null && this.elementName.equals(xcname)) {
            return this;
        }
        for (int i = 0; i < this.size(); ++i) {
            XComponent tmpxc = this.elementAt(i).find(xcname);
            if (tmpxc == null) continue;
            return tmpxc;
        }
        return null;
    }

    public Vector getAllCanSelected(XContainer container, Vector v) {
        if (v == null) {
            v = new Vector<XComponent>();
        }
        int sz = container.size();
        for (int i = 0; i < sz; ++i) {
            XComponent tmpE = container.elementAt(i);
            if (tmpE.canSelected()) {
                v.addElement(tmpE);
                continue;
            }
            if (!(tmpE instanceof XContainer)) continue;
            ((XContainer)tmpE).getAllCanSelected((XContainer)tmpE, v);
        }
        return v;
    }
}

