/*
 * Decompiled with CFR 0.152.
 */
package xmlui;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class Utf8Reader {
    private InputStream is = null;

    Utf8Reader(InputStream is) {
        this.is = is;
    }

    public int read() throws IOException {
        char ch = '\u0000';
        int tmpChar = 0;
        tmpChar = this.is.read();
        if (tmpChar == -1) {
            return tmpChar;
        }
        int char1 = tmpChar & 0xFF;
        switch (char1 >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ch = (char)char1;
                break;
            }
            case 12: 
            case 13: {
                int char2 = this.is.read();
                if ((char2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                ch = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                break;
            }
            case 14: {
                int char2 = this.is.read();
                int char3 = this.is.read();
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                ch = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                break;
            }
            default: {
                throw new UTFDataFormatException();
            }
        }
        return ch;
    }

    public void skip(long l) throws IOException {
        this.is.skip(l);
    }

    public static final String entoutf(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputstream = new DataOutputStream(baos);
            outputstream.writeUTF(s);
            byte[] b = baos.toByteArray();
            StringBuffer strbuffer = new StringBuffer();
            for (int i = 2; i < b.length; ++i) {
                if (Integer.toHexString(b[i]).length() > 2) {
                    strbuffer.append('%');
                    strbuffer.append(Integer.toHexString(b[i]).substring(6, Integer.toHexString(b[i]).length()).toLowerCase());
                    continue;
                }
                strbuffer.append((char)b[i]);
            }
            return strbuffer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

