/*
 * Decompiled with CFR 0.152.
 */
package xmlui;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import xmlui.Para;
import xmlui.XActionListener;
import xmlui.XCanvas;
import xmlui.XComponent;
import xmlui.XCustomPanel;
import xmlui.XForm;
import xmlui.XImage;
import xmlui.gscript.Lib;

public abstract class ResManager {
    private static byte[][] IMG_IDS = new byte[][]{{0, 0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}, {0, 6}, {0, 7}, {0, 8}, {0, 9}, {1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}};
    public static final int SYSTEM_IMG_REAL_COUNT = 9;
    public static final int SYSTEM_IMG_COUNT = 18;
    public static final int SYS_IMG = 10000;
    public static final int SYS_IMG_1 = 10001;
    public static final int SYS_IMG_3 = 10020;
    public static final int SYS_IMG_2 = 10010;
    public static final int SYS_IMG_WIDTH = 16;
    public static final int SYS_IMG_HEIGHT = 16;
    public static final byte TITIL_MAIN = 0;
    public static final byte TITIL_UAFMSG = 1;
    public static final byte TITIL_FIREND = 2;
    public static final byte TITIL_FOLLOW = 3;
    public static final byte TITIL_REVERT = 4;
    public static final byte TITIL_MYSPACE = 5;
    public static final byte TITIL_DMESSAGE = 6;
    public static final byte TITIL_MYDMESSAGE = 7;
    public static final byte TITIL_LOOKA = 8;
    public static final byte TITIL_OTHSPACE = 9;
    public static byte[][] imgStreamArray;
    public static String[] imgName;
    static XImage[] sysImg;
    private static DirectGraphics dg;
    public static int NO_TRANSFORM;
    public static int FLIP_HORIZONTAL;
    public static int FLIP_VERTICAL;
    public static int ROTATE_90;
    public static int ROTATE_180;
    public static int ROTATE_270;
    public static int ROTATE_90_FLIP_HORIZ;
    public static int ROTATE_90_FLIP_VERT;

    public ResManager(String resHomeDir) {
        this.loadImg(resHomeDir);
    }

    public abstract XImage getImageA(int var1);

    public abstract void drawA(Graphics var1, int var2, int var3, int var4, int var5);

    public abstract int getImgWA(int var1);

    public abstract int getImgHA(int var1);

    public abstract void drawA(Graphics var1, short[] var2, int var3, int var4, int var5, int var6, int var7);

    public abstract int getImgWA(short[] var1);

    public abstract int getImgHA(short[] var1);

    public final XImage getImage(int id) {
        if (id >= 10000 && id < 10020) {
            return null;
        }
        if (id >= 10020) {
            return sysImg[8];
        }
        if (id < 18) {
            return sysImg[IMG_IDS[id][0]];
        }
        return this.getImageA(id - 18);
    }

    public final void draw(Graphics g, int id, int x, int y, int transfor) {
        if (id >= 10000 && id < 10010) {
            return;
        }
        if (id == 10020) {
            g.setColor(65535);
            g.drawRect(x, y, this.getImgW(id), this.getImgH(id));
        } else if (id >= 10010) {
            sysImg[8].draw(g, x, y, 0, transfor);
        } else if (id < 18) {
            sysImg[IMG_IDS[id][0]].draw(g, x, y, IMG_IDS[id][1], transfor);
        } else {
            this.drawA(g, id - 18, x, y, transfor);
        }
    }

    public final void draw(Graphics g, short[] eq, int x, int y, int w, int h, int transfor) {
        this.drawA(g, eq, x, y, w, h, transfor);
    }

    public final int getImgW(short[] eq) {
        return this.getImgWA(eq);
    }

    public final int getImgH(short[] eq) {
        return this.getImgHA(eq);
    }

    public final int getImgW(int id) {
        if (id >= 10000) {
            return 16;
        }
        if (id >= 10010) {
            return ResManager.sysImg[8].frame_w;
        }
        if (id < 18) {
            return ResManager.sysImg[ResManager.IMG_IDS[id][0]].frame_w;
        }
        return this.getImgWA(id - 18);
    }

    public final int getImgH(int id) {
        if (id >= 10000) {
            return 16;
        }
        if (id >= 10010) {
            return ResManager.sysImg[8].frame_h;
        }
        if (id < 18) {
            return ResManager.sysImg[ResManager.IMG_IDS[id][0]].frame_h;
        }
        return this.getImgHA(id - 18);
    }

    public void loadImg(String resHome) {
        sysImg = new XImage[9];
        for (int i = 0; i < 9; ++i) {
            try {
                if (resHome == null) {
                    resHome = "/";
                }
                if (!resHome.endsWith("/")) {
                    resHome = resHome + "/";
                }
                String p = resHome + "xmlui/" + i + ".png";
                if (i == 0) {
                    ResManager.sysImg[i] = new XImage(p, 5, 7);
                    continue;
                }
                ResManager.sysImg[i] = new XImage(p);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void drawRim(Graphics g, int x, int y, int w, int h, int type) {
        switch (type) {
            case 0: 
            case 3: {
                break;
            }
            case 1: {
                byte aw = Para.fontH;
                g.setColor(0);
                g.fillRect(++x, y, w -= 2, aw + 2);
                g.fillRect(x, y + h - aw - 2, w, aw + 2);
                break;
            }
            case 2: {
                g.setColor(0);
                g.drawRect(x, y, w, h);
                g.drawRect(x + 2, y + 2, w - 4, h - 4);
                g.setColor(16764244);
                g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
                g.setColor(14523953);
                g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                g.setColor(11228160);
                g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
                this.draw(g, 5, x, y, 0);
                this.draw(g, 5, x, y + h - this.getImgH(5) + 1, FLIP_VERTICAL);
                this.draw(g, 5, x + w - this.getImgW(5) + 1, y, FLIP_HORIZONTAL);
                this.draw(g, 5, x + w - this.getImgW(5) + 1, y + h - this.getImgH(5) + 1, ROTATE_180);
            }
        }
    }

    public void drawNumber(Graphics g, int number, int x, int y) {
        byte[] fig = new byte[3];
        int nb = number;
        fig[0] = (byte)(nb / 100);
        fig[1] = (byte)(nb % 100 / 10);
        fig[2] = (byte)(nb % 10);
        for (int i = 0; i < 2; ++i) {
            if (fig[i] != 0) continue;
            fig[i] = -1;
        }
        if (fig[0] > 0) {
            this.draw(g, fig[0], x, y, 0);
        } else {
            x -= 4;
        }
        if (fig[0] > 0 || fig[1] > 0) {
            this.draw(g, fig[1], x + 4, y, 0);
        }
        this.draw(g, fig[2], x + 8, y, 0);
    }

    public void drawNumbers(Graphics g, int x, int y, int w) {
        for (int i = 0; i < 9; ++i) {
            this.draw(g, i, x + w * i + 2, y, 0);
        }
    }

    public static int getUI(int id) {
        byte cn = XComponent.SysC;
        if (cn > 3) {
            cn = 0;
        }
        if (id > 0 && id < 5 && cn > 0) {
            id += 161 + (cn - 1) * 4;
        }
        return id;
    }

    public static int readUtf8Char(InputStream is) {
        char ch = '\u0000';
        try {
            int tmpChar = 0;
            tmpChar = is.read();
            if (tmpChar == -1) {
                return tmpChar;
            }
            int char1 = (tmpChar ^= 0xFF) & 0xFF;
            switch (char1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ch = (char)char1;
                    break;
                }
                case 12: 
                case 13: {
                    int char2 = is.read() ^ 0xFF;
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    ch = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    int char2 = is.read() ^ 0xFF;
                    int char3 = is.read() ^ 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    ch = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return ch;
    }

    public static int readUtf8CharO(InputStream is) {
        char ch = '\u0000';
        try {
            int tmpChar = 0;
            tmpChar = is.read();
            if (tmpChar == -1) {
                return tmpChar;
            }
            int char1 = tmpChar & 0xFF;
            switch (char1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ch = (char)char1;
                    break;
                }
                case 12: 
                case 13: {
                    int char2 = is.read();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    ch = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    int char2 = is.read();
                    int char3 = is.read();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    ch = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return ch;
    }

    public static final String replace(String s1, String s2, String s3) {
        if (s1 == null || s2 == null || s3 == null) {
            return s1;
        }
        try {
            while (-1 != s1.indexOf(s2)) {
                s1 = s1.substring(0, s1.indexOf(s2)) + s3 + s1.substring(s1.indexOf(s2) + s2.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s1;
    }

    public static InputStream str2utf8is(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(s);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] tmpb = new byte[baos.size() - 2];
        System.arraycopy(baos.toByteArray(), 2, tmpb, 0, tmpb.length);
        return new ByteArrayInputStream(tmpb);
    }

    public static String getField(String s, int index) {
        StringBuffer newsb = new StringBuffer();
        if (s != null) {
            try {
                int counter = 0;
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char curch = s.charAt(i);
                    if (curch == ':') {
                        ++counter;
                        continue;
                    }
                    if (index != counter - 1) {
                        if (index != counter) continue;
                        newsb.append(curch);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newsb.toString();
    }

    public static String setField(String s, int index, String n) {
        StringBuffer newsb = new StringBuffer();
        boolean isadd = false;
        if (s != null) {
            try {
                int counter = 0;
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char curch = s.charAt(i);
                    if (curch == ':') {
                        ++counter;
                    }
                    if (index == counter) {
                        if (isadd) continue;
                        isadd = true;
                        if (index != 0) {
                            newsb.append(":");
                        }
                        newsb.append(n);
                        continue;
                    }
                    newsb.append(curch);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newsb.toString();
    }

    public static void drawRegion(Graphics g, Image img, int xSrc, int ySrc, int width, int height, int transform, int xDest, int yDest, int antor) {
        if (transform == NO_TRANSFORM || transform == FLIP_HORIZONTAL || transform == FLIP_VERTICAL || transform == ROTATE_180) {
            g.setClip(xDest, yDest, width, height);
        } else if (transform == ROTATE_90 || transform == ROTATE_270 || transform == ROTATE_90_FLIP_HORIZ || transform == ROTATE_90_FLIP_VERT) {
            g.setClip(xDest, yDest, height, width);
        }
        g.setColor(0xFF0000);
        ResManager.drawRegionMap(g, img, xSrc, ySrc, width, height, transform, xDest, yDest, antor);
        g.setClip(0, 0, XCanvas.screenW, XCanvas.screenH);
    }

    public static void drawRegionMap1(Graphics g, Image img, int xSrc, int ySrc, int width, int height, int transform, int xDest, int yDest, int antor) {
        int xOffset = 0;
        int yOffset = 0;
        if (transform == NO_TRANSFORM) {
            xOffset = xSrc;
            yOffset = ySrc;
            g.drawImage(img, xDest - xOffset, yDest - yOffset, 20);
        } else {
            dg = DirectUtils.getDirectGraphics((Graphics)g);
            if (transform == FLIP_HORIZONTAL) {
                xOffset = xSrc;
                yOffset = ySrc;
            } else if (transform == FLIP_VERTICAL) {
                xOffset = xSrc;
                yOffset = ySrc;
            } else if (transform == ROTATE_90) {
                xOffset = ySrc;
                yOffset = xSrc;
            } else if (transform == ROTATE_180) {
                xOffset = xSrc;
                yOffset = ySrc;
            } else if (transform == ROTATE_270) {
                xOffset = ySrc;
                yOffset = xSrc;
            } else if (transform == ROTATE_90_FLIP_HORIZ) {
                xOffset = ySrc;
                yOffset = xSrc;
            } else if (transform == ROTATE_90_FLIP_VERT) {
                xOffset = ySrc;
                yOffset = xSrc;
            }
            dg.drawImage(img, xDest - xOffset, yDest - yOffset, 20, transform);
        }
    }

    public static void drawRegionMap(Graphics g, Image img, int xSrc, int ySrc, int width, int height, int transform, int xDest, int yDest, int antor) {
        int xOffset = 0;
        int yOffset = 0;
        if (transform == NO_TRANSFORM) {
            xOffset = xSrc;
            yOffset = ySrc;
            g.drawImage(img, xDest - xOffset, yDest - yOffset, 20);
        } else {
            dg = DirectUtils.getDirectGraphics((Graphics)g);
            if (transform == FLIP_HORIZONTAL) {
                xOffset = img.getWidth() - xSrc - width;
                yOffset = ySrc;
            } else if (transform == FLIP_VERTICAL) {
                xOffset = xSrc;
                yOffset = img.getHeight() - ySrc - height;
            } else if (transform == ROTATE_90) {
                xOffset = ySrc;
                yOffset = img.getWidth() - xSrc - width;
            } else if (transform == ROTATE_180) {
                xOffset = img.getWidth() - xSrc - width;
                yOffset = img.getHeight() - ySrc - height;
            } else if (transform == ROTATE_270) {
                xOffset = img.getHeight() - ySrc - height;
                yOffset = xSrc;
            } else if (transform == ROTATE_90_FLIP_HORIZ) {
                xOffset = img.getHeight() - ySrc - height;
                yOffset = img.getWidth() - xSrc - width;
            } else if (transform == ROTATE_90_FLIP_VERT) {
                xOffset = ySrc;
                yOffset = xSrc;
            }
            dg.drawImage(img, xDest - xOffset, yDest - yOffset, 20, transform);
        }
    }

    public static void clearImageRes() {
        imgStreamArray = null;
        imgName = null;
        System.gc();
    }

    private static byte[] compagesPng(byte[][] result, int[] splitLen) throws Exception {
        int i;
        int len = 0;
        for (int j = 0; j < 3; ++j) {
            len += result[j].length;
        }
        byte[] pngBytes = new byte[len];
        for (i = 0; i < splitLen[0]; ++i) {
            pngBytes[i] = (byte)(127 - result[0][i]);
        }
        for (i = 0; i < splitLen[2]; ++i) {
            pngBytes[i + splitLen[0]] = (byte)(127 - result[2][i]);
        }
        for (i = 0; i < splitLen[1]; ++i) {
            pngBytes[i + splitLen[0] + splitLen[2]] = (byte)(127 - result[1][i]);
        }
        return pngBytes;
    }

    protected static short compagesShortBytes(byte[] bytes) {
        int tempi = (bytes[1] & 0xFF) << 8;
        return (short)(tempi |= bytes[0] & 0xFF);
    }

    protected static int compagesBytes(byte[] bytes) {
        int tempi = (bytes[3] & 0xFF) << 24;
        tempi |= (bytes[2] & 0xFF) << 16;
        tempi |= (bytes[1] & 0xFF) << 8;
        return tempi |= bytes[0] & 0xFF;
    }

    public static String[] split(String str, int width, char token) {
        return ResManager.split(str, width, token, true);
    }

    public static String[] split(String str, int width, char token, boolean flag) {
        int length = str.length();
        Vector<String> tmp = new Vector<String>();
        block0: for (int i = 0; i < length; ++i) {
            String string = "";
            for (int j = 0; j < width; ++j) {
                char c = str.charAt(i);
                string = string + c;
                if (i == length - 1) {
                    tmp.addElement(string);
                    continue block0;
                }
                if (c == '\n' && flag || c == token) {
                    tmp.addElement(string);
                    continue block0;
                }
                if (j == width - 1) {
                    if (flag) {
                        string = string + "\n";
                    }
                    tmp.addElement(string);
                    continue block0;
                }
                ++i;
            }
        }
        String[] result = new String[tmp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((String)tmp.elementAt(i)).replace(token, ' ').trim();
        }
        return result;
    }

    public static String[] split(String str, char token) {
        int length = str.length();
        Vector<String> tmp = new Vector<String>();
        block0: for (int i = 0; i < length; ++i) {
            String string = "";
            for (int j = 0; j < length; ++j) {
                char c = str.charAt(i);
                string = string + c;
                if (i == length - 1) {
                    tmp.addElement(string);
                    continue block0;
                }
                if (c == token) {
                    tmp.addElement(string);
                    continue block0;
                }
                ++i;
            }
        }
        String[] result = new String[tmp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((String)tmp.elementAt(i)).replace(token, ' ').trim();
        }
        return result;
    }

    public static XForm creatForm(XCanvas xc, InputStream is, XActionListener listener, XCustomPanel cp, Lib[] libs) {
        XForm xf = new XForm(xc, listener);
        try {
            xf.parseXml(is, "form");
        }
        catch (Exception e) {
            xf = null;
            e.printStackTrace();
            return null;
        }
        if (xf.getUsePanel()) {
            xf.setUpAdapter(cp);
        }
        if (xc.getFrontestForm() != null) {
            xc.getFrontestForm().setFrontForm(xf);
        } else {
            xc.setFrontForm(xf);
        }
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                Lib lib = libs[i];
                xf.getInp().register(lib);
            }
        }
        return xf;
    }

    static {
        sysImg = null;
        dg = null;
        NO_TRANSFORM = 0;
        FLIP_HORIZONTAL = 8192;
        FLIP_VERTICAL = 16384;
        ROTATE_90 = 90;
        ROTATE_180 = 180;
        ROTATE_270 = 270;
        ROTATE_90_FLIP_HORIZ = 8282;
        ROTATE_90_FLIP_VERT = ROTATE_90 | FLIP_VERTICAL;
    }
}

