/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class UITextArea
extends UIComponent {
    private UIScroll scroll = null;
    private String str = null;
    private short pointer = 0;
    private short fullRows = 0;
    private short canShowRows = 0;
    private String[] textStr = null;
    private String[] textStr_1 = null;
    private boolean isGreen = true;
    private int color = 8349245;
    private boolean noRim = false;

    public void setShowRim(boolean isShow) {
        this.noRim = !isShow;
    }

    public boolean getCanShowAll() {
        return this.fullRows <= this.canShowRows;
    }

    public UITextArea(int x, int y, int w, int h, String str) {
        super(x, y, w, h);
        this.setString(str);
    }

    public void setString(String _str) {
        this.str = null;
        this.str = _str;
        if (this.str == null) {
            this.str = " ";
        }
        this.textStr = null;
        this.textStr_1 = Util.wrapText(this.str, this.width - 6, font);
        this.textStr = Util.colorChangeLine(this, this.str, this.width - 6, font);
        this.scroll = null;
        if (this.isGreen) {
            this.fullRows = (short)this.textStr.length;
            this.canShowRows = (short)((this.height - 4) / (charH + 1));
        } else {
            this.fullRows = (short)this.textStr_1.length;
            this.canShowRows = (short)((this.height - 4) / (charH + 1));
        }
        if (this.canShowRows < this.fullRows) {
            this.scroll = new UIScroll(this.positionX + this.width - 4, this.positionY, 4, this.height * 208 / CURR_H, 0, false);
            this.scroll.setBar(this.fullRows, this.canShowRows);
        }
    }

    public void setXY(int x, int y) {
        this.positionX = x;
        this.positionY = y;
        if (this.scroll != null) {
            this.scroll.setXY(this.positionX + this.width - 4, this.positionY);
        }
    }

    public void draw(Graphics g) {
        int length;
        if (!this.focus) {
            g.setColor(0xFFF000);
        } else {
            g.setColor(0xFFFFFF);
        }
        if (!this.noRim) {
            UIRim.drawRim(g, this.positionX, this.positionY, this.width, this.height, (byte)0);
        }
        if ((length = !this.isGreen ? this.textStr_1.length : this.textStr.length) > this.canShowRows) {
            length = this.pointer + this.canShowRows;
        }
        if (!this.isGreen) {
            int i = this.pointer;
            int j = 0;
            while (i < length) {
                g.drawString(this.textStr_1[i], this.positionX + 4, this.positionY + 4 + charH * j, 20);
                ++i;
                ++j;
            }
        } else {
            int i = this.pointer;
            int j = 0;
            while (i < length) {
                int offSet = 0;
                char[] tmpChars = this.textStr[i].toCharArray();
                for (int m = 0; m < tmpChars.length; ++m) {
                    if (this.colorSigns[i][m] == 0) {
                        g.setColor(this.color);
                    } else {
                        g.setColor(65280);
                    }
                    g.drawChar(tmpChars[m], this.positionX + offSet + 4, this.positionY + 4 + j * (charH + 1), 20);
                    offSet += font.charWidth(tmpChars[m]);
                }
                ++i;
                ++j;
            }
        }
        if (this.scroll != null) {
            this.scroll.draw(g);
        }
    }

    public UIComponent getAroundComponent(byte direction) {
        switch (direction) {
            case 1: {
                this.up();
                return null;
            }
            case 2: {
                this.down();
                return null;
            }
        }
        return null;
    }

    public void up() {
        if (this.pointer > 0) {
            this.pointer = (short)(this.pointer - 1);
        }
        if (this.scroll != null) {
            this.scroll.setScrollPosition(this.pointer);
        }
    }

    public void down() {
        if (this.pointer + this.canShowRows < this.fullRows) {
            this.pointer = (short)(this.pointer + 1);
        }
        if (this.scroll != null) {
            this.scroll.setScrollPosition(this.pointer);
        }
    }

    public void setColor(int c) {
        this.color = c;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setChangeColor(boolean change) {
        this.isGreen = change;
    }

    public boolean isEnd() {
        return this.pointer + this.canShowRows >= this.fullRows;
    }

    public boolean isTop() {
        return this.pointer == 0;
    }

    public short getPointer() {
        return this.pointer;
    }

    public void setPointer(short pointer) {
        this.pointer = pointer;
    }

    public String getStr() {
        return this.str;
    }
}

