/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MImage {
    public Image img;
    public short frame_w = 0;
    public short frame_h = 0;
    public byte cols = 0;
    public byte rows = 0;
    public byte frames = 0;

    public MImage(String imagePath, String pkgPath, int f_w, int f_h) {
        if (f_w == 0 || f_h == 0) {
            return;
        }
        this.frame_w = (short)f_w;
        this.frame_h = (short)f_h;
        if (!imagePath.equals("")) {
            this.img = Util.loadImage(Util.readPKG(pkgPath, imagePath));
        }
        this.cols = (byte)(this.img.getWidth() / this.frame_w);
        this.rows = (byte)(this.img.getHeight() / this.frame_h);
        this.frames = (byte)(this.cols * this.rows);
    }

    public MImage(Image img) {
        if (img == null) {
            return;
        }
        this.img = img;
        this.frame_w = (short)img.getWidth();
        this.frame_h = (short)img.getHeight();
        this.frames = 1;
        this.rows = 1;
        this.cols = 1;
    }

    public MImage(String s) {
        if (!s.equals("")) {
            this.img = Util.loadImage(s);
        }
        this.frame_w = (short)this.img.getWidth();
        this.frame_h = (short)this.img.getHeight();
        this.cols = 1;
        this.rows = 1;
        this.frames = 1;
    }

    public void draw(Graphics g, int x, int y, int frameIndex, boolean ifMir) {
        if (this.img == null) {
            return;
        }
        if (ifMir && this.cols != 1) {
            frameIndex = this.cols * this.rows - 1 - frameIndex;
        }
        int dx = this.frame_w * (frameIndex % this.cols);
        int dy = this.frame_h * (frameIndex / this.cols);
        g.setClip(x, y, (int)this.frame_w, (int)this.frame_h);
        if (!ifMir) {
            g.drawImage(this.img, x - dx, y - dy, 20);
        } else {
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            dg.drawImage(this.img, x - dx, y - dy, 20, 8192);
        }
        g.setClip(0, 0, MainCanvas.screenW, MainCanvas.screenH);
    }

    public void draw(Graphics g, int x, int y, int anchor, int transform) {
        if (transform == 0) {
            g.drawImage(this.img, x, y, anchor);
        } else {
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            dg.drawImage(this.img, x, y, anchor, transform);
        }
    }
}

