/*
 * Decompiled with CFR 0.152.
 */
public class IntList {
    private static final int DEFAULT_SIZE = 8;
    private int[] arr = new int[8];
    private int pos;

    public IntList() {
        this(8);
    }

    public IntList(int size) {
        if (size > 8) {
            this.arr = new int[size];
        }
    }

    public IntList(IntList list) {
        this.addAll(list);
    }

    public void add(int v) {
        this.ensureCap(1);
        this.arr[this.pos] = v;
        ++this.pos;
    }

    public void addAt(int index, int v) {
        this.ensureCap(1);
        if (this.pos - index > 0) {
            System.arraycopy(this.arr, index, this.arr, index + 1, this.pos - index);
        }
        this.arr[index] = v;
        ++this.pos;
    }

    public void addAll(IntList list) {
        this.ensureCap(list.arr.length);
        System.arraycopy(list.arr, 0, this.arr, this.pos, list.pos);
        this.pos += list.pos;
    }

    public void set(int index, int v) {
        if (index < 0 || index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.arr[index] = v;
    }

    public void remove(int v) {
        int real = 0;
        for (int i = 0; i < this.pos; ++i) {
            this.arr[real] = this.arr[i];
            if (this.arr[i] == v) continue;
            ++real;
        }
        this.pos = real;
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.arr, index + 1, this.arr, index, this.arr.length - index - 1);
        --this.pos;
    }

    public void removeAll(IntList list) {
        for (int i = 0; i < list.pos; ++i) {
            this.remove(list.get(i));
        }
    }

    public boolean contains(int v) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.arr[i] != v) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int v) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.arr[i] != v) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.pos;
    }

    public boolean isEmpty() {
        return this.pos == 0;
    }

    public void setSize(int size) {
        if (this.pos >= size) {
            this.pos = size;
        } else {
            for (int i = this.pos; i < size; ++i) {
                this.add(0);
            }
        }
    }

    public int get(int index) {
        if (index < 0 || index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.arr[index];
    }

    public void clear() {
        this.pos = 0;
    }

    public void inverse() {
        int imax = this.pos / 2;
        for (int i = 0; i < imax; ++i) {
            int thatEnd = this.pos - 1 - i;
            int tmp = this.arr[i];
            this.arr[i] = this.arr[thatEnd];
            this.arr[thatEnd] = tmp;
        }
    }

    private void ensureCap(int reqSize) {
        if (this.pos + reqSize >= this.arr.length) {
            int[] narr = new int[(int)((float)(this.pos + reqSize) * 1.5f)];
            System.arraycopy(this.arr, 0, narr, 0, this.pos);
            this.arr = narr;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < this.pos; ++i) {
            sb.append(this.arr[i]);
            if (i >= this.pos - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public int[] getArray() {
        return this.arr;
    }
}

