/*
 * Decompiled with CFR 0.152.
 */
public class ByteArray {
    private static final byte DEFAULT_SIZE = 16;
    public static final byte BOOLEAN_SIZE = 1;
    public static final byte BYTE_SIZE = 1;
    public static final byte CHAR_SIZE = 2;
    public static final byte SHORT_SIZE = 2;
    public static final byte INT_SIZE = 4;
    public static final byte LONG_SIZE = 8;
    private int currentPos = 0;
    private byte[] data;

    public ByteArray() {
        this(16);
    }

    public ByteArray(int size) {
        this.data = new byte[size];
        this.currentPos = 0;
    }

    public ByteArray(byte[] src) {
        this.data = src;
        this.currentPos = 0;
    }

    public void writeBoolean(boolean val) {
        this.ensureCapacity(1);
        this.data[this.currentPos++] = (byte)(val ? 1 : 0);
    }

    public void writeByte(byte val) {
        this.ensureCapacity(1);
        this.data[this.currentPos++] = val;
    }

    public void writeByte(int val) {
        this.writeByte((byte)val);
    }

    public void writeChar(char c) {
        this.ensureCapacity(2);
        this.data[this.currentPos + 1] = (byte)(c >>> 0);
        this.data[this.currentPos + 0] = (byte)(c >>> 8);
        this.currentPos += 2;
    }

    public void writeShort(short val) {
        this.ensureCapacity(2);
        this.data[this.currentPos + 1] = (byte)(val >>> 0);
        this.data[this.currentPos + 0] = (byte)(val >>> 8);
        this.currentPos += 2;
    }

    public void writeShort(int val) {
        this.writeShort((short)val);
    }

    public void writeInt(int val) {
        this.ensureCapacity(4);
        this.data[this.currentPos + 3] = (byte)(val >>> 0);
        this.data[this.currentPos + 2] = (byte)(val >>> 8);
        this.data[this.currentPos + 1] = (byte)(val >>> 16);
        this.data[this.currentPos + 0] = (byte)(val >>> 24);
        this.currentPos += 4;
    }

    public void writeLong(long val) {
        this.ensureCapacity(8);
        this.data[this.currentPos + 7] = (byte)(val >>> 0);
        this.data[this.currentPos + 6] = (byte)(val >>> 8);
        this.data[this.currentPos + 5] = (byte)(val >>> 16);
        this.data[this.currentPos + 4] = (byte)(val >>> 24);
        this.data[this.currentPos + 3] = (byte)(val >>> 32);
        this.data[this.currentPos + 2] = (byte)(val >>> 40);
        this.data[this.currentPos + 1] = (byte)(val >>> 48);
        this.data[this.currentPos + 0] = (byte)(val >>> 56);
        this.currentPos += 8;
    }

    public void writeByteArray(byte[] src) {
        if (src == null) {
            return;
        }
        this.ensureCapacity(src.length);
        System.arraycopy(src, 0, this.data, this.currentPos, src.length);
        this.currentPos += src.length;
    }

    public void writeUTF(String str) {
        this.writeByteArray(ByteArray.getByteArrFromUTF(str));
    }

    public boolean readBoolean() {
        return this.data[this.currentPos++] != 0;
    }

    public byte readByte() {
        return this.data[this.currentPos++];
    }

    public char readChar() {
        char c = (char)(((this.data[this.currentPos + 1] & 0xFF) << 0) + ((this.data[this.currentPos + 0] & 0xFF) << 8));
        this.currentPos += 2;
        return c;
    }

    public short readShort() {
        short s = (short)(((this.data[this.currentPos + 1] & 0xFF) << 0) + ((this.data[this.currentPos + 0] & 0xFF) << 8));
        this.currentPos += 2;
        return s;
    }

    public int readInt() {
        int i = ((this.data[this.currentPos + 3] & 0xFF) << 0) + ((this.data[this.currentPos + 2] & 0xFF) << 8) + ((this.data[this.currentPos + 1] & 0xFF) << 16) + ((this.data[this.currentPos + 0] & 0xFF) << 24);
        this.currentPos += 4;
        return i;
    }

    public long readLong() {
        long l = (((long)this.data[this.currentPos + 7] & 0xFFL) << 0) + (((long)this.data[this.currentPos + 6] & 0xFFL) << 8) + (((long)this.data[this.currentPos + 5] & 0xFFL) << 16) + (((long)this.data[this.currentPos + 4] & 0xFFL) << 24) + (((long)this.data[this.currentPos + 3] & 0xFFL) << 32) + (((long)this.data[this.currentPos + 2] & 0xFFL) << 40) + (((long)this.data[this.currentPos + 1] & 0xFFL) << 48) + (((long)this.data[this.currentPos + 0] & 0xFFL) << 56);
        this.currentPos += 8;
        return l;
    }

    public byte[] readByteArray(int length) {
        if (length == -1 || this.currentPos + length > this.data.length) {
            length = this.data.length - this.currentPos;
        }
        byte[] temp = new byte[length];
        System.arraycopy(this.data, this.currentPos, temp, 0, length);
        this.currentPos += length;
        return temp;
    }

    public byte[] readByteArray(int off, int length) {
        if (length == -1 || off + length > this.data.length) {
            length = this.data.length - off;
        }
        byte[] temp = new byte[length];
        System.arraycopy(this.data, off, temp, 0, length);
        return temp;
    }

    public String readUTF2() {
        int count = 0;
        byte[] bytearr = this.data;
        int c = 0;
        byte char2 = 0;
        byte char3 = 0;
        StringBuffer sb = new StringBuffer();
        block5: while (count < this.data.length) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    sb.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    char2 = bytearr[(count += 2) - 1];
                    sb.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    char2 = bytearr[(count += 3) - 2];
                    char3 = bytearr[count - 1];
                    sb.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
        }
        return sb.toString();
    }

    public String readUTF() {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        if (utflen == -1) {
            System.err.println("Error!! ByteArray: readUTF()");
            return "ERROR";
        }
        byte[] bytearr = null;
        char[] chararr = null;
        bytearr = this.readByteArray(utflen);
        if (utflen > bytearr.length) {
            return null;
        }
        chararr = new char[utflen];
        int chararr_count = 0;
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    byte char2 = bytearr[(count += 2) - 1];
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    byte char2 = bytearr[(count += 3) - 2];
                    byte char3 = bytearr[count - 1];
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }

    private void ensureCapacity(int length) {
        if (this.currentPos + length >= this.data.length) {
            byte[] tmp = new byte[this.data.length + 2 * length];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    public static byte[] getByteArrFromUTF(String str) {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        return bytearr;
    }

    private int readUnsignedByte() {
        return this.data[this.currentPos++] & 0xFF;
    }

    private int readUnsignedShort() {
        int ch2;
        int ch1 = this.readUnsignedByte();
        if ((ch1 | (ch2 = this.readUnsignedByte())) < 0) {
            return -1;
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public byte[] toByteArray() {
        if (this.currentPos < this.data.length) {
            return this.readByteArray(0, this.currentPos);
        }
        return this.data;
    }

    public void resetPosition() {
        this.currentPos = 0;
    }

    public void close() {
        this.data = null;
    }

    public static int[] bytesToInts(byte[] bytes) {
        if (bytes == null || bytes.length < 4) {
            return null;
        }
        int[] ints = new int[bytes.length >> 2];
        ByteArray ba = new ByteArray(bytes);
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = ba.readInt();
        }
        return ints;
    }

    public static byte[] intsToBytes(int[] ints) {
        if (ints == null || ints.length <= 0) {
            return null;
        }
        byte[] bytes = new byte[ints.length << 2];
        ByteArray ba = new ByteArray(bytes);
        for (int i = 0; i < ints.length; ++i) {
            ba.writeInt(ints[i]);
        }
        return ba.toByteArray();
    }
}

