/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Astar {
    public static final int FOUR_DIRECTION = 0;
    public static final int EIGHT_DIRECTION = 1;
    private static final int MERGE_NUM = 10000;

    public static IntList findPath(PathableMap mi, int curCol, int curRow, int aimCol, int aimRow, int stepLimit, int direction) {
        IntList pathList = new IntList();
        if (!mi.isPassable(aimCol, aimRow)) {
            return pathList;
        }
        int cols = mi.getCols();
        int startSpot = curRow * cols + curCol;
        int endSpot = aimRow * cols + aimCol;
        Vector<Node> openList = new Vector<Node>();
        Vector<Node> closeList = new Vector<Node>();
        Node node = new Node(startSpot, 0, 0);
        openList.addElement(node);
        int count = 0;
        boolean endFlag = false;
        while (!endFlag && openList.size() != 0 && count++ <= stepLimit) {
            node = Astar.findMinF(openList);
            openList.removeElement(node);
            closeList.addElement(node);
            if (node.index == endSpot) {
                endFlag = true;
                break;
            }
            for (int i = 0; i < 9; ++i) {
                int r2;
                int offColumn;
                int offRow;
                int index;
                int c2;
                int r1;
                int c1;
                if (direction == 0 && i % 2 == 0 || !mi.canFromTo(c1 = node.index % cols, r1 = node.index / cols, c2 = (index = node.index + (offRow = i / 3 - 1) * cols + (offColumn = i % 3 - 1)) % cols, r2 = index / cols) || Astar.findNode(closeList, index) != null) continue;
                Node checkedNode = Astar.findNode(openList, index);
                if (checkedNode == null) {
                    int currentRow = index / cols;
                    int currentColumn = index % cols;
                    int endR = endSpot / cols;
                    int endC = endSpot % cols;
                    int H = (Math.abs(endR - currentRow) + Math.abs(endC - currentColumn)) * 10;
                    checkedNode = Math.abs(offRow) == Math.abs(offColumn) ? new Node(index, node.G + 14, H) : new Node(index, node.G + 10, H);
                    checkedNode.parent = node;
                    openList.addElement(checkedNode);
                    continue;
                }
                int d = checkedNode.index - node.index;
                int g = 0;
                g = d == node.index - cols - 1 || d == node.index - cols + 1 || d == node.index + cols - 1 || d == node.index + cols + 1 ? node.G + 14 : node.G + 10;
                if (checkedNode.G <= g) continue;
                checkedNode.parent = node;
                checkedNode.G = g;
                checkedNode.F = checkedNode.G + checkedNode.H;
            }
        }
        if (endFlag) {
            node = (Node)closeList.elementAt(closeList.size() - 1);
            while (node != null) {
                pathList.addAt(0, Astar.mergeColRow(node.index % cols, node.index / cols));
                node = node.parent;
            }
        }
        return pathList;
    }

    public static int mergeColRow(int col, int row) {
        return col * 10000 + row;
    }

    public static int getColFromMerge(int merge) {
        return merge / 10000;
    }

    public static int getRowFromMerge(int merge) {
        return merge % 10000;
    }

    private static final Node findMinF(Vector list) {
        Node minNode = (Node)list.elementAt(0);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)list.elementAt(i);
            if (node.F >= minNode.F) continue;
            minNode = node;
        }
        return minNode;
    }

    private static final Node findNode(Vector list, int index) {
        Node node = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)list.elementAt(i);
            if (node.index != index) continue;
            return node;
        }
        return null;
    }
}

